/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file COM/COM_RfCarrier.c                                                  */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-07                                                           */
/*                                                                            */
/* @brief This file contains functions to control the RF transmission carrier.*/
/******************************************************************************/

#ifndef __DEF_H_WSFR48_16_COM_RFCARRIER__
#define __DEF_H_WSFR48_16_COM_RFCARRIER__

/* *************************** STANDARD INCLUDES **************************** */

#include <stdbool.h>

/* **************************** CUSTOM INCLUDES ***************************** */

#include "stm32l0xx_hal.h"

/* *************************** TYPES DECLARATION **************************** */

/* ******************************* CONSTANTS ******************************** */

/* **************************** GLOBAL VARIABLES **************************** */

/* ************************* FUNCTIONS DECLARATION ************************** */

/******************************************************************************/
/* @function COM_ManageRfCarrier                                              */
/*                                                                            */
/* @brief Manages the RF transmission carrier.                                */
/* @param [in] rfCarrierActivationStatus RF carrier activation command        */
/* @pre The RF carrier control context must have been initialized by          */
/*      COM_RfCarrier_Init                                                    */
/* @req SYS_REQ-0603-001 : Redressage du signal RS_DATA                       */
/* @req SYS_REQ-0604-001 : Génération de la porteuse                          */
/******************************************************************************/
void COM_ManageRfCarrier(const bool rfCarrierActivationStatus);

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/

#endif /* __DEF_H_WSFR48_16_COM_RFCARRIER__ */
