/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file COM/COM_Transmission.h                                               */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-12                                                           */
/*                                                                            */
/* @brief This file contains functions to transmit data to remote equipments. */
/******************************************************************************/

#ifndef __DEF_H_WSFR48_16_COM_TRANSMISSION__
#define __DEF_H_WSFR48_16_COM_TRANSMISSION__

/* *************************** STANDARD INCLUDES **************************** */

#include <stdbool.h>

/* **************************** CUSTOM INCLUDES ***************************** */

#include "stm32l0xx_hal.h"
#include "COM_RsData.h"

/* *************************** TYPES DECLARATION **************************** */

/* ******************************* CONSTANTS ******************************** */

/* **************************** GLOBAL VARIABLES **************************** */

/* ************************* FUNCTIONS DECLARATION ************************** */

/******************************************************************************/
/* @function COM_Transmission_Init                                            */
/*                                                                            */
/* @brief Initializes the transmission interface for remote equipments.       */
/* @param [in] UartHandler UART serial transmission line handler              */
/* @req SYS_REQ-0602-001 : Transmission des données RS_DATA                   */
/******************************************************************************/
void COM_Transmission_Init(UART_HandleTypeDef * const UartHandler);

/******************************************************************************/
/* @function COM_Transmission_SendData                                        */
/*                                                                            */
/* @brief Sends data to remote equipment.                                     */
/* @param [in] buffer Content to send on RS_DATA transmission line            */
/* @pre Transmission context must have been initialized with                  */
/*      COM_Transmission_Init                                                 */
/* @req SYS_REQ-0602-001 : Transmission des données RS_DATA                   */
/******************************************************************************/
void COM_Transmission_SendData(const tRsDataBuffer buffer);

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/

#endif /* __DEF_H_WSFR48_16_COM_TRANSMISSION__ */
