/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file CONF/CONF_ApplyCmds.c                                                */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-14                                                           */
/*                                                                            */
/* @brief This file contains functions to apply administration commands.      */
/******************************************************************************/

/* *************************** STANDARD INCLUDES **************************** */

/* **************************** CUSTOM INCLUDES ***************************** */

#include "CONF_ApplyCmds.h"

/* ******************************** DEFINES ********************************* */

/* *************************** TYPES DECLARATION **************************** */

/* ******************************* CONSTANTS ******************************** */

/* **************************** GLOBAL VARIABLES **************************** */

/* **************************** STATIC VARIABLES **************************** */

/* ********************** STATIC FUNCTIONS DECLARATION ********************** */

/* ************************* FUNCTIONS DECLARATION ************************** */

/* ********************** STATIC FUNCTIONS DEFINITION *********************** */

/* ************************** FUNCTIONS DEFINITION ************************** */

/******************************************************************************/
/* @function CONF_Update_Calendar                                             */
/*                                                                            */
/* @brief Selects the new system calendar based on previous calendar and      */
/*        administration command received.                                    */
/* @param [in] previousCalendar Current system calendar                       */
/* @param [in] newCalendar New calendar received from administration command  */
/* @retval New system calendar                                                */
/* @req SYS_REQ-0309-001 : Modification du calendrier                         */
/******************************************************************************/
tTIME_Calendar CONF_Update_Calendar(const tTIME_Calendar previousCalendar, const tTIME_Calendar newCalendar)
{
    if(newCalendar > E_CALENDAR_UNKNOWN && newCalendar < E_NB_CALENDAR)
    {
        return newCalendar;
    }
    return previousCalendar;
}

/******************************************************************************/
/* @function CONF_Update_Timestamp                                            */
/*                                                                            */
/* @brief Selects the new system reference timestamp based on previous        */
/*        calendar and administration command received.                       */
/* @param [in] newReferenceTimestamp New reference timestamp received from    */
/*                                   administration command                   */
/* @req SYS_REQ-0310-001 : Modification du timestamp                          */
/******************************************************************************/
void CONF_Update_Timestamp(const tTIME_Timestamp newReferenceTimestamp)
{
    if(newReferenceTimestamp != C_UNDEFINED_TIMESTAMP)
    {
        TIME_SetReferenceTimestamp(newReferenceTimestamp * ((tTIME_Timestamp)C_NB_MS_IN_S));
    }
}

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
