/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file CONF/CONF_ApplyCmds.h                                                */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-14                                                           */
/*                                                                            */
/* @brief This file contains functions to apply administration commands.      */
/******************************************************************************/

#ifndef __DEF_H_WSFR48_16_CONF_APPLYCMDS__
#define __DEF_H_WSFR48_16_CONF_APPLYCMDS__

/* *************************** STANDARD INCLUDES **************************** */

/* **************************** CUSTOM INCLUDES ***************************** */

#include "TIME.h"

/* ******************************* CONSTANTS ******************************** */

/* *************************** TYPES DECLARATION **************************** */

/* **************************** GLOBAL VARIABLES **************************** */

/* ************************* FUNCTIONS DECLARATION ************************** */

/******************************************************************************/
/* @function CONF_Update_Calendar                                             */
/*                                                                            */
/* @brief Selects the new system calendar based on previous calendar and      */
/*        administration command received.                                    */
/* @param [in] previousCalendar Current system calendar                       */
/* @param [in] newCalendar New calendar received from administration command  */
/* @retval New system calendar                                                */
/* @req SYS_REQ-0309-001 : Modification du calendrier                         */
/******************************************************************************/
tTIME_Calendar CONF_Update_Calendar(const tTIME_Calendar previousCalendar, const tTIME_Calendar newCalendar);

/******************************************************************************/
/* @function CONF_Update_Timestamp                                            */
/*                                                                            */
/* @brief Selects the new system reference timestamp based on previous        */
/*        calendar and administration command received.                       */
/* @param [in] newReferenceTimestamp New reference timestamp received from    */
/*                                   administration command                   */
/* @req SYS_REQ-0310-001 : Modification du timestamp                          */
/******************************************************************************/
void CONF_Update_Timestamp(const tTIME_Timestamp newReferenceTimestamp);

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/

#endif /* __DEF_H_WSFR48_16_CONF_APPLYCMDS__ */
