/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file PWR/PWR.h                                                            */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-06                                                           */
/*                                                                            */
/* @brief This file contains functions to monitor system power supply.        */
/******************************************************************************/

#ifndef __DEF_H_WSFR48_16_PWR__
#define __DEF_H_WSFR48_16_PWR__

/* *************************** STANDARD INCLUDES **************************** */

/* **************************** CUSTOM INCLUDES ***************************** */

#include "stm32l0xx_hal.h"

/* *************************** TYPES DECLARATION **************************** */

typedef enum
{
    E_POWERSOURCE_P = 0,
    E_POWERSOURCE_N,
    E_NB_POWERSOURCE
} tPWR_PowerSource;

/* ******************************* CONSTANTS ******************************** */

/* **************************** GLOBAL VARIABLES **************************** */

/* ************************* FUNCTIONS DECLARATION ************************** */

/******************************************************************************/
/* @function PWR_ReadPowerSourceVoltage                                       */
/*                                                                            */
/* @brief Reads the voltage of a board power supply.                          */
/* @param [in] powerSource Power supply source to read                        */
/* @retval Power supply voltage if the power source is known; NaN otherwise.  */
/* @req SYS_REQ-0106-001 : Numérisation de la tension d'alimentation positive */
/* @req SYS_REQ-0107-001 : Numérisation de la tension d'alimentation négative */
/******************************************************************************/
double PWR_ReadPowerSourceVoltage(const tPWR_PowerSource powerSource);

/******************************************************************************/
/* @function PWR_Init                                                         */
/*                                                                            */
/* @brief Initializes power supply monitoring context.                        */
/* @param [in|out] adcHandler Analog to digital converter handler             */
/* @retval Result value of HAL_ADC_Start_DMA function.                        */
/* @req None                                                                  */
/******************************************************************************/
HAL_StatusTypeDef PWR_Init(ADC_HandleTypeDef * const adcHandler);

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/

#endif /* __DEF_H_WSFR48_16_PWR__ */
