/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file SUP/SUP_PushButtons.c                                                */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-06                                                           */
/*                                                                            */
/* @brief This file contains the context and functions to monitor CPU health. */
/******************************************************************************/

/* *************************** STANDARD INCLUDES **************************** */

/* **************************** CUSTOM INCLUDES ***************************** */

#include "stm32l0xx_hal.h"
#include "SUP_CPU.h"

/* ******************************** DEFINES ********************************* */

#define C_OPECYCLE_ALLOCATED_DURATION ((double)1000.0) /* 1 s = 1000 ms       */
#define C_PERCENTAGE_FACTOR (100.0)

/* *************************** TYPES DECLARATION **************************** */

/* ******************************* CONSTANTS ******************************** */

/* **************************** GLOBAL VARIABLES **************************** */

/* **************************** STATIC VARIABLES **************************** */

/* ********************** STATIC FUNCTIONS DECLARATION ********************** */

/* ************************* FUNCTIONS DECLARATION ************************** */

/* ********************** STATIC FUNCTIONS DEFINITION *********************** */

/* ************************** FUNCTIONS DEFINITION ************************** */

/******************************************************************************/
/* @function SUP_CPU_CpuClock                                                 */
/*                                                                            */
/* @brief Gets the CPU main clock frequency.                                  */
/* @retval CPU main clock frequency (Hz)                                      */
/* @req SYS_REQ-0211-001 : Fréquence CPU                                      */
/******************************************************************************/
double SUP_CPU_CpuClock(void)
{
    return (double)SystemCoreClock;
}

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
