/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file SUP/SUP_PushButtons.h                                                */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-06                                                           */
/*                                                                            */
/* @brief This file contains the context and functions to monitor CPU health. */
/******************************************************************************/

#ifndef __DEF_H_WSFR48_16_SUP_CPU__
#define __DEF_H_WSFR48_16_SUP_CPU__

/* *************************** STANDARD INCLUDES **************************** */

/* **************************** CUSTOM INCLUDES ***************************** */

/* *************************** TYPES DECLARATION **************************** */

/* ******************************* CONSTANTS ******************************** */

/* **************************** GLOBAL VARIABLES **************************** */

/* ************************* FUNCTIONS DECLARATION ************************** */

/******************************************************************************/
/* @function SUP_CPU_CpuClock                                                 */
/*                                                                            */
/* @brief Gets the CPU main clock frequency.                                  */
/* @retval CPU main clock frequency (Hz)                                      */
/* @req SYS_REQ-0211-001 : Fréquence CPU                                      */
/******************************************************************************/
double SUP_CPU_CpuClock(void);

/******************************************************************************/
/* @function SUP_CPU_ComputeCpuLoad                                           */
/*                                                                            */
/* @brief Computes the CPU load.                                              */
/* @param [in] previousCycleStartDate Start date of the previous cycle (ms)   */
/* @param [in] currentCycleStartDate Start date of the current cycle (ms)     */
/* @retval CPU load (%)                                                       */
/* @req SYS_REQ-0212-001 : Charge CPU                                         */
/******************************************************************************/
double SUP_CPU_ComputeCpuLoad
(
    const unsigned int previousCycleStartDate,
    const unsigned int currentCycleStartDate
);

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/

#endif /* __DEF_H_WSFR48_16_SUP_CPU__ */
