/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file TIME/TIME.c                                                          */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-07                                                           */
/*                                                                            */
/* @brief This file contains functions to compute date and time.              */
/******************************************************************************/

/* *************************** STANDARD INCLUDES **************************** */

#include <math.h>

/* **************************** CUSTOM INCLUDES ***************************** */

#include "TIME.h"

/* ******************************** DEFINES ********************************* */

#define C_YEAR_MOD_4   (  4)
#define C_YEAR_MOD_100 (100)
#define C_YEAR_MOD_400 (400)
#define C_LEAPTIME_HOR ( 23)
#define C_LEAPTIME_MIN ( 59)
#define C_LEAPTIME_SEC ( 60)

/* *************************** TYPES DECLARATION **************************** */

typedef enum
{
    E_LEAPSEC_1972_06_30 = 0,
    E_LEAPSEC_1972_12_31,
    E_LEAPSEC_1973_12_31,
    E_LEAPSEC_1974_12_31,
    E_LEAPSEC_1975_12_31,
    E_LEAPSEC_1976_12_31,
    E_LEAPSEC_1977_12_31,
    E_LEAPSEC_1978_12_31,
    E_LEAPSEC_1979_12_31,
    E_LEAPSEC_1981_06_30,
    E_LEAPSEC_1982_06_30,
    E_LEAPSEC_1983_06_30,
    E_LEAPSEC_1985_06_30,
    E_LEAPSEC_1987_12_31,
    E_LEAPSEC_1989_12_31,
    E_LEAPSEC_1990_12_31,
    E_LEAPSEC_1992_06_30,
    E_LEAPSEC_1993_06_30,
    E_LEAPSEC_1994_06_30,
    E_LEAPSEC_1995_12_31,
    E_LEAPSEC_1997_06_30,
    E_LEAPSEC_1998_12_31,
    E_LEAPSEC_2005_12_31,
    E_LEAPSEC_2008_12_31,
    E_LEAPSEC_2012_06_30,
    E_LEAPSEC_2015_06_30,
    E_LEAPSEC_2016_12_31,
    E_NB_LEAPSECONDS
} tTIME_LeapSeconds;

/* ******************************* CONSTANTS ******************************** */

const char C_TIME_CALENDAR_LONGNAME[E_NB_CALENDAR][C_TIME_CALENDAR_NAME_MAXLENGTH] = {"<UNDEFINED>", "JULIAN", "GREGORIAN", "UTC"};
const char C_TIME_CALENDAR_SHRTNAME[E_NB_CALENDAR][C_TIME_CALENDAR_NAME_MAXLENGTH] = {"UNK"        , "JUL"   , "GRE"      , "UTC"};

static const long C_NUMBER_OF_DAYS_PER_MONTH_NOTBISSEXTILE[E_NB_MONTHS] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
static const long C_NUMBER_OF_DAYS_PER_MONTH_BISSEXTILE   [E_NB_MONTHS] = {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

static const tTIME_Timestamp C_LEAPSECONDS[E_NB_LEAPSECONDS] =
{
    78796800  , /* E_LEAPSEC_1972_06_30 */
    94694400  , /* E_LEAPSEC_1972_12_31 */
    126230400 , /* E_LEAPSEC_1973_12_31 */
    157766400 , /* E_LEAPSEC_1974_12_31 */
    189302400 , /* E_LEAPSEC_1975_12_31 */
    220924800 , /* E_LEAPSEC_1976_12_31 */
    252460800 , /* E_LEAPSEC_1977_12_31 */
    283996800 , /* E_LEAPSEC_1978_12_31 */
    315532800 , /* E_LEAPSEC_1979_12_31 */
    362793600 , /* E_LEAPSEC_1981_06_30 */
    394329600 , /* E_LEAPSEC_1982_06_30 */
    425865600 , /* E_LEAPSEC_1983_06_30 */
    489024000 , /* E_LEAPSEC_1985_06_30 */
    567993600 , /* E_LEAPSEC_1987_12_31 */
    631152000 , /* E_LEAPSEC_1989_12_31 */
    662688000 , /* E_LEAPSEC_1990_12_31 */
    709948800 , /* E_LEAPSEC_1992_06_30 */
    741484800 , /* E_LEAPSEC_1993_06_30 */
    773020800 , /* E_LEAPSEC_1994_06_30 */
    820454400 , /* E_LEAPSEC_1995_12_31 */
    867715200 , /* E_LEAPSEC_1997_06_30 */
    883612800 , /* E_LEAPSEC_1998_12_31 */
    1136073600, /* E_LEAPSEC_2005_12_31 */
    1230768000, /* E_LEAPSEC_2008_12_31 */
    1341100800, /* E_LEAPSEC_2012_06_30 */
    1435708800, /* E_LEAPSEC_2015_06_30 */
    1483228800  /* E_LEAPSEC_2016_12_31 */
};

/* **************************** GLOBAL VARIABLES **************************** */

/* **************************** STATIC VARIABLES **************************** */

/* ********************** STATIC FUNCTIONS DECLARATION ********************** */

/* ************************* FUNCTIONS DECLARATION ************************** */

/* ********************** STATIC FUNCTIONS DEFINITION *********************** */

/* ************************** FUNCTIONS DEFINITION ************************** */

/******************************************************************************/
/* @function TIME_ComputeDate                                                 */
/*                                                                            */
/* @brief Computes the current date and time.                                 */
/* @param [in] calendar Calendar used by the system                           */
/* @param [in] timestamp Current timestamp                                    */
/* @retval Current date and time in specified calendar                        */
/* @req SYS_REQ-0503-001 : Calcul de l’horodatage                             */
/******************************************************************************/
tTIME_CalendarDate TIME_ComputeDate
(
    const tTIME_Calendar calendar,
    const tTIME_Timestamp timestamp
)
{
    tTIME_CalendarDate currentDate;

    currentDate.validity = false;
    currentDate.calendar = E_CALENDAR_UNKNOWN;
    currentDate.year     = C_UNDEFINED_DATE_YEAR;
    currentDate.month    = C_UNDEFINED_DATE_MONTH;
    currentDate.day      = C_UNDEFINED_DATE_DAY;
    currentDate.hour     = C_UNDEFINED_DATE_HOUR;
    currentDate.minute   = C_UNDEFINED_DATE_MINUTE;
    currentDate.second   = C_UNDEFINED_DATE_SECOND;

    return currentDate;
}

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
