/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

#include <stdio.h>
#include <stdbool.h>
#include <string.h>

#include "ADA1655.h"
#include "SUP_PushButtons.h"
#include "CONF_SystemStates.h"
#include "PWR.h"
#include "SCR.h"
#include "SUP_CPU.h"
#include "SUP_Reception.h"
#include "SUP_RsAdmin.h"
#include "SUP_ApplyCmds.h"
#include "CONF_ApplyCmds.h"
#include "COM_RsData.h"
#include "COM_Transmission.h"
#include "COM_RfCarrier.h"

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
ADC_HandleTypeDef hadc;
DMA_HandleTypeDef hdma_adc;

I2C_HandleTypeDef hi2c1;

TIM_HandleTypeDef htim21;
TIM_HandleTypeDef htim22;

UART_HandleTypeDef huart1;
DMA_HandleTypeDef hdma_usart1_rx;

/* USER CODE BEGIN PV */

tAda1655 ADA1655_handler;

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
static void MX_GPIO_Init(void);
static void MX_DMA_Init(void);
static void MX_I2C1_Init(void);
static void MX_TIM22_Init(void);
static void MX_ADC_Init(void);
static void MX_TIM21_Init(void);
static void MX_USART1_UART_Init(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/******************************************************************************/
/* @function CORE_LED_Init                                                    */
/*                                                                            */
/* @brief Initializes the RGB LED.                                            */
/* @req None                                                                  */
/******************************************************************************/
void CORE_LED_Init(void)
{
    /* ---- Hardware initialization ----------------------------------------- */
    __HAL_RCC_GPIOA_CLK_ENABLE();
    GPIO_InitTypeDef GPIO_InitStruct = {0};
    GPIO_InitStruct.Pin = LED_RGB_Pin;
    GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
    GPIO_InitStruct.Pull = GPIO_NOPULL;
    GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
    HAL_GPIO_Init(LED_RGB_GPIO_Port, &GPIO_InitStruct);

    /* ---- Set RGB LED to initialization color ----------------------------- */
    ADA1655_SetControlPin(&ADA1655_handler, LED_RGB_GPIO_Port, LED_RGB_Pin);
    ADA1655_Reset(&ADA1655_handler);
    ADA1655_SetColor(&ADA1655_handler, 255, 255, 0);
}

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{

  /* USER CODE BEGIN 1 */

  /* ======================================================================== */
  /* @req SYS_REQ-0005-002 : Ordonnancement des opérations                    */
  /* ======================================================================== */
  /* Software operations shall be executed in the following order:            */
  /* 1) Dataflows initialization                                              */
  /* 2) Hardware peripheral configuration                                     */
  /* 3) < Unused step (provision) >                                           */
  /* While no software stop command has been received:                        */
  /* 4) Cycle beginning timestamp (ignore for first iteration)                */
  /* 5) Administration commands reception                                     */
  /* 6) Administration commands processing                                    */
  /* 7) User buttons reading                                                  */
  /* 8) System configuration update                                           */
  /* 9) Computation of following informations:                                */
  /*    - Date and time                                                       */
  /*    - System power supply voltages                                        */
  /*    - Previous cycle CPU load                                             */
  /*    - Internal clocks frequencies                                         */
  /* 10) Control of transmission interface for remote equipments              */
  /* 11) Information transmission to remote equipments                        */
  /* 12) Information display on user screen                                   */
  /* ------------------------------------------------------------------------ */

  double PS_P_VOLTAGE;
  double PS_N_VOLTAGE;
  bool V_BTN_DISP;
  bool V_BTN_MODE;
  tTIME_Timestamp CURRENT_CYCLE_START_DATE;
  tTIME_Timestamp PREVIOUS_CYCLE_START_DATE;
  double CPU_CLOCK;
  double CPU_LOAD;
  tTIME_Calendar CALENDAR;
  tTIME_Calendar NEW_CALENDAR;
  tTIME_Timestamp CURRENT_TIMESTAMP;
  tTIME_Timestamp NEW_TIMESTAMP;
  bool RF_CARRIER_ACTIVE;
  tCONF_SystemStates SYSTEM_STATE;
  tTIME_CalendarDate CURRENT_DATE;
  double FCLK;
  tRsDataBuffer rsDataOutputBuffer;
  tRsAdminBuffer rsAdminInputBuffer;
  unsigned int nbCmdsReceived;
  tRsAdmin_Cmd CMDS[C_RSADMININ_MAX_CMDS];
  tPingIds PING_IDS;

  bool firstCycle;
  bool stopCmdReceived;

  /* ======================================================================== */
  /* @req SYS_REQ-0005-002 : Ordonnancement des opérations > Step 1           */
  /* @req SYS_REQ-0006-001 : Initialisation des flux logiciels                */
  /* ======================================================================== */
  /* All software dataflows shall be initialized before "real time" execution */
  /* according to data ranges and accuracies definitions.                     */
  /* ------------------------------------------------------------------------ */
  PS_P_VOLTAGE              = 0.0;
  PS_N_VOLTAGE              = 0.0;
  V_BTN_DISP                = false;
  V_BTN_MODE                = false;
  CURRENT_CYCLE_START_DATE  = 0;
  PREVIOUS_CYCLE_START_DATE = 0;
  CPU_CLOCK                 = 0.0;
  CPU_LOAD                  = 0.0;
  CALENDAR                  = E_CALENDAR_UTC;
  NEW_CALENDAR              = E_NB_CALENDAR;
  CURRENT_TIMESTAMP         = C_UNDEFINED_TIMESTAMP;
  NEW_TIMESTAMP             = C_UNDEFINED_TIMESTAMP;
  RF_CARRIER_ACTIVE         = true;
  SYSTEM_STATE              = E_STATE_HOME;
  CURRENT_DATE.calendar     = CALENDAR;
  CURRENT_DATE.validity     = false;
  CURRENT_DATE.year         = C_UNDEFINED_DATE_YEAR;
  CURRENT_DATE.month        = C_UNDEFINED_DATE_MONTH;
  CURRENT_DATE.day          = C_UNDEFINED_DATE_DAY;
  CURRENT_DATE.hour         = C_UNDEFINED_DATE_HOUR;
  CURRENT_DATE.minute       = C_UNDEFINED_DATE_MINUTE;
  CURRENT_DATE.second       = C_UNDEFINED_DATE_SECOND;
  FCLK                      = 32000000.0; // TODO Link to SYS_REQ-0211-001
  memset(rsDataOutputBuffer, 0, sizeof(tRsDataBuffer));
  memset(rsAdminInputBuffer, 0, sizeof(tRsAdminBuffer));
  nbCmdsReceived = 0;
  memset(CMDS, 0, C_RSADMININ_MAX_CMDS * sizeof(tRsAdmin_Cmd));
  memset(PING_IDS, 0, sizeof(tPingIds));

  firstCycle                = true;
  stopCmdReceived           = false;
  /* ======================================================================== */

  /* ======================================================================== */
  /* @req SYS_REQ-0005-002 : Ordonnancement des opérations > Step 2           */
  /* ======================================================================== */
  /* Hardware peripheral configuration                                        */
  /* ------------------------------------------------------------------------ */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* ---- RGB LED initialization -------------------------------------------- */
  /* RGB LED is configured before any other peripheral to display "init"      */
  /* state LED color.                                                         */
  CORE_LED_Init();
  /* ------------------------------------------------------------------------ */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_DMA_Init();
  MX_I2C1_Init();
  MX_TIM22_Init();
  MX_ADC_Init();
  MX_TIM21_Init();
  MX_USART1_UART_Init();
  /* USER CODE BEGIN 2 */

  /* ---- Initialization of module's internal contexts ---------------------- */
  if(PWR_Init(&hadc) != HAL_OK) { Error_Handler(); }
  SCR_Init();
  SUP_PushButtons_Init(BTN_MODE_GPIO_Port, BTN_MODE_Pin, BTN_DISP_GPIO_Port, BTN_DISP_Pin);
  SUP_Reception_Init(&huart1);
  COM_Transmission_Init(&huart1);
  /* ------------------------------------------------------------------------ */

  /* ---- Enabling interrupts ----------------------------------------------- */
  HAL_TIM_Base_Start_IT(&htim21);
  HAL_TIM_Base_Start_IT(&htim22);

  /* ======================================================================== */
  /* @req SYS_REQ-0005-002 : Ordonnancement des opérations > Step 3           */
  /* ======================================================================== */
  /* < Unused step (provision) >                                              */
  /* ------------------------------------------------------------------------ */

  /* ======================================================================== */
  /* End of initialization                                                    */
  /* ======================================================================== */
  ADA1655_SetColor(&ADA1655_handler, 0, 0, 0);
  snprintf(rsDataOutputBuffer, C_COM_TRANSMIT_BUFFER_MAX_LENGTH, "SyncOrSink startup complete!\n");
  COM_Transmission_SendData(rsDataOutputBuffer);

  /* ------------------------------------------------------------------------ */
  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */

  /* ======================================================================== */
  /* @req SYS_REQ-0005-002 : Ordonnancement des opérations > Real time        */
  /* ======================================================================== */
  /* While no software stop command has been received...                      */
  /* ------------------------------------------------------------------------ */
  while (!stopCmdReceived)
  {
    /* ====================================================================== */
    /* @req SYS_REQ-0005-002 : Ordonnancement des opérations > Step 4         */
    /* @req SYS_REQ-0210-001 : Horodatage du cycle                            */
    /* ====================================================================== */
    if(firstCycle) { firstCycle = false; }
    else
    {
        PREVIOUS_CYCLE_START_DATE = CURRENT_CYCLE_START_DATE;
        CURRENT_CYCLE_START_DATE = TIME_GetTimeElapsedSinceStartup();
    }

    /* ====================================================================== */
    /* @req SYS_REQ-0005-002 : Ordonnancement des opérations > Step 5         */
    /* ====================================================================== */
    /* Administration commands reception                                      */
    /* ---------------------------------------------------------------------- */
    SUP_Reception_ReceiveData(rsAdminInputBuffer);
    nbCmdsReceived = SUP_RsAdmin_DecodeCommand(rsAdminInputBuffer, CMDS);

    /* ====================================================================== */
    /* @req SYS_REQ-0005-002 : Ordonnancement des opérations > Step 6         */
    /* ====================================================================== */
    /* Administration commands processing                                     */
    /* ---------------------------------------------------------------------- */
    SUP_RsAdmin_SelectCommandsToApply(nbCmdsReceived, CMDS);
    SUP_ProcessAdminCommands(nbCmdsReceived, CMDS, PING_IDS, &NEW_CALENDAR, &NEW_TIMESTAMP);
    CALENDAR = CONF_Update_Calendar(CALENDAR, NEW_CALENDAR);
    CONF_Update_Timestamp(NEW_TIMESTAMP);

    /* ====================================================================== */
    /* @req SYS_REQ-0005-002 : Ordonnancement des opérations > Step 7         */
    /* ====================================================================== */
    /* User buttons reading                                                   */
    /* ---------------------------------------------------------------------- */
    SUP_PushButtons_ReadCurrentStates(&V_BTN_MODE, &V_BTN_DISP);

    if(V_BTN_MODE) { ADA1655_SetColor(&ADA1655_handler, 255,   0, 0); }
    if(V_BTN_DISP) { ADA1655_SetColor(&ADA1655_handler,   0, 255, 0); }
    else           { ADA1655_SetColor(&ADA1655_handler,   0,   0, 0); }

    /* ====================================================================== */
    /* @req SYS_REQ-0005-002 : Ordonnancement des opérations > Step 8         */
    /* ====================================================================== */
    /* System configuration update                                            */
    /* ---------------------------------------------------------------------- */
    SYSTEM_STATE = CONF_SystemState_Select(SYSTEM_STATE, V_BTN_DISP);
    CONF_UpdateContextWithMODE(SYSTEM_STATE, V_BTN_MODE, &CALENDAR, &RF_CARRIER_ACTIVE);

    /* ====================================================================== */
    /* @req SYS_REQ-0005-002 : Ordonnancement des opérations > Step 9         */
    /* ====================================================================== */
    /* Computation of following informations:                                 */
    /* - Date and time                                                        */
    /* - System power supply voltages                                         */
    /* - Previous cycle CPU load                                              */
    /* - Internal clocks frequencies                                          */
    /* ---------------------------------------------------------------------- */

    CURRENT_TIMESTAMP = TIME_GetTimestamp();
    CURRENT_DATE = TIME_ComputeDate(CALENDAR, CURRENT_TIMESTAMP);
    PS_P_VOLTAGE = PWR_ReadPowerSourceVoltage(E_POWERSOURCE_P);
    PS_N_VOLTAGE = PWR_ReadPowerSourceVoltage(E_POWERSOURCE_N);
    CPU_CLOCK = SUP_CPU_CpuClock();

    /* ====================================================================== */
    /* @req SYS_REQ-0005-002 : Ordonnancement des opérations > Step 10        */
    /* ====================================================================== */
    /* Control of transmission interface for remote equipments                */
    /* ---------------------------------------------------------------------- */
    COM_ManageRfCarrier(RF_CARRIER_ACTIVE);

    /* ====================================================================== */
    /* @req SYS_REQ-0005-002 : Ordonnancement des opérations > Step 11        */
    /* ====================================================================== */
    /* Information transmission to remote equipments                          */
    /* ---------------------------------------------------------------------- */
    COM_Messages_Build_RSDATA
    (
        RF_CARRIER_ACTIVE,
        PING_IDS,
        CALENDAR,
        NEW_CALENDAR,
        NEW_TIMESTAMP,
        rsDataOutputBuffer
    );
    COM_Transmission_SendData(rsDataOutputBuffer);

    /* ====================================================================== */
    /* @req SYS_REQ-0005-002 : Ordonnancement des opérations > Step 12        */
    /* ====================================================================== */
    /* Information display on user screen                                     */
    /* ---------------------------------------------------------------------- */

    SCR_DisplayContent
    (
        SYSTEM_STATE,
        &CURRENT_DATE,
        PS_P_VOLTAGE,
        PS_N_VOLTAGE,
        CPU_CLOCK,
        CPU_LOAD,
        FCLK,
        &htim21,
        &htim22,
        RF_CARRIER_ACTIVE
    );

    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};
  RCC_PeriphCLKInitTypeDef PeriphClkInit = {0};

  /** Configure the main internal regulator output voltage
  */
  __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSI;
  RCC_OscInitStruct.PLL.PLLMUL = RCC_PLLMUL_4;
  RCC_OscInitStruct.PLL.PLLDIV = RCC_PLLDIV_2;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_1) != HAL_OK)
  {
    Error_Handler();
  }
  PeriphClkInit.PeriphClockSelection = RCC_PERIPHCLK_USART1|RCC_PERIPHCLK_I2C1;
  PeriphClkInit.Usart1ClockSelection = RCC_USART1CLKSOURCE_PCLK2;
  PeriphClkInit.I2c1ClockSelection = RCC_I2C1CLKSOURCE_PCLK1;
  if (HAL_RCCEx_PeriphCLKConfig(&PeriphClkInit) != HAL_OK)
  {
    Error_Handler();
  }
}

/**
  * @brief ADC Initialization Function
  * @param None
  * @retval None
  */
static void MX_ADC_Init(void)
{

  /* USER CODE BEGIN ADC_Init 0 */

  /* USER CODE END ADC_Init 0 */

  ADC_ChannelConfTypeDef sConfig = {0};

  /* USER CODE BEGIN ADC_Init 1 */

  /* USER CODE END ADC_Init 1 */

  /** Configure the global features of the ADC (Clock, Resolution, Data Alignment and number of conversion)
  */
  hadc.Instance = ADC1;
  hadc.Init.OversamplingMode = DISABLE;
  hadc.Init.ClockPrescaler = ADC_CLOCK_SYNC_PCLK_DIV2;
  hadc.Init.Resolution = ADC_RESOLUTION_12B;
  hadc.Init.SamplingTime = ADC_SAMPLETIME_160CYCLES_5;
  hadc.Init.ScanConvMode = ADC_SCAN_DIRECTION_FORWARD;
  hadc.Init.DataAlign = ADC_DATAALIGN_RIGHT;
  hadc.Init.ContinuousConvMode = ENABLE;
  hadc.Init.DiscontinuousConvMode = DISABLE;
  hadc.Init.ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_NONE;
  hadc.Init.ExternalTrigConv = ADC_SOFTWARE_START;
  hadc.Init.DMAContinuousRequests = ENABLE;
  hadc.Init.EOCSelection = ADC_EOC_SINGLE_CONV;
  hadc.Init.Overrun = ADC_OVR_DATA_PRESERVED;
  hadc.Init.LowPowerAutoWait = DISABLE;
  hadc.Init.LowPowerFrequencyMode = DISABLE;
  hadc.Init.LowPowerAutoPowerOff = DISABLE;
  if (HAL_ADC_Init(&hadc) != HAL_OK)
  {
    Error_Handler();
  }

  /** Configure for the selected ADC regular channel to be converted.
  */
  sConfig.Channel = ADC_CHANNEL_0;
  sConfig.Rank = ADC_RANK_CHANNEL_NUMBER;
  if (HAL_ADC_ConfigChannel(&hadc, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }

  /** Configure for the selected ADC regular channel to be converted.
  */
  sConfig.Channel = ADC_CHANNEL_1;
  if (HAL_ADC_ConfigChannel(&hadc, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN ADC_Init 2 */

  /* USER CODE END ADC_Init 2 */

}

/**
  * @brief I2C1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_I2C1_Init(void)
{

  /* USER CODE BEGIN I2C1_Init 0 */

  /* USER CODE END I2C1_Init 0 */

  /* USER CODE BEGIN I2C1_Init 1 */

  /* USER CODE END I2C1_Init 1 */
  hi2c1.Instance = I2C1;
  hi2c1.Init.Timing = 0x00B07CB4;
  hi2c1.Init.OwnAddress1 = 0;
  hi2c1.Init.AddressingMode = I2C_ADDRESSINGMODE_7BIT;
  hi2c1.Init.DualAddressMode = I2C_DUALADDRESS_DISABLE;
  hi2c1.Init.OwnAddress2 = 0;
  hi2c1.Init.OwnAddress2Masks = I2C_OA2_NOMASK;
  hi2c1.Init.GeneralCallMode = I2C_GENERALCALL_DISABLE;
  hi2c1.Init.NoStretchMode = I2C_NOSTRETCH_DISABLE;
  if (HAL_I2C_Init(&hi2c1) != HAL_OK)
  {
    Error_Handler();
  }

  /** Configure Analogue filter
  */
  if (HAL_I2CEx_ConfigAnalogFilter(&hi2c1, I2C_ANALOGFILTER_ENABLE) != HAL_OK)
  {
    Error_Handler();
  }

  /** Configure Digital filter
  */
  if (HAL_I2CEx_ConfigDigitalFilter(&hi2c1, 0) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN I2C1_Init 2 */

  /* USER CODE END I2C1_Init 2 */

}

/**
  * @brief TIM21 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM21_Init(void)
{

  /* USER CODE BEGIN TIM21_Init 0 */

  /* USER CODE END TIM21_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_MasterConfigTypeDef sMasterConfig = {0};

  /* USER CODE BEGIN TIM21_Init 1 */

  /* ======================================================================== */
  /* Time elapsed since startup                                               */
  /* @req SYS_REQ-0501-002 : Temps écoulé depuis le démarrage du système > Configuration du timer */
  /* ======================================================================== */
  /* Time elapsed since startup is incremented by TIM21. TIM21 interrupt      */
  /* frequency is set by MX_TIM21_Init and TIME_ELAPSED_SINCE_STARTUP         */
  /* dataflow is incremented by TIM21_IRQHandler function.                    */
  /* TIM21 config is set as follows:                                          */
  /* - Fclk = 32 MHz                                                          */
  /* - PSC  = 0                                                               */
  /* - ARR  = 31999                                                           */
  /* Finterrupt = Fclk / ((PSC+1)(ARR+1)) = 32.10^6/(1*32000) = 1 kHz         */
  /*                                                          => T = 1 ms     */
  /* ------------------------------------------------------------------------ */

  /* USER CODE END TIM21_Init 1 */
  htim21.Instance = TIM21;
  htim21.Init.Prescaler = 0;
  htim21.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim21.Init.Period = 31999;
  htim21.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim21.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim21) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim21, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  sMasterConfig.MasterOutputTrigger = TIM_TRGO_RESET;
  sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
  if (HAL_TIMEx_MasterConfigSynchronization(&htim21, &sMasterConfig) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM21_Init 2 */

  /* USER CODE END TIM21_Init 2 */

}

/**
  * @brief TIM22 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM22_Init(void)
{

  /* USER CODE BEGIN TIM22_Init 0 */

  /* USER CODE END TIM22_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_MasterConfigTypeDef sMasterConfig = {0};

  /* USER CODE BEGIN TIM22_Init 1 */

  /* ======================================================================== */
  /* Button state reading frequency                                           */
  /* @req SYS_REQ-0208-002 : Bouton utilisateur "MODE" > Fréquence de lecture */
  /* @req SYS_REQ-0209-002 : Bouton utilisateur "DISP" > Fréquence de lecture */
  /* ======================================================================== */
  /* Button states are read by TIM22. TIM22 interrupt frequency is set by     */
  /* MX_TIM22_Init and button states are read by TIM22_IRQHandler function.   */
  /* TIM22 config is set as follows:                                          */
  /* - Fclk = 32 MHz                                                          */
  /* - PSC  = 7                                                               */
  /* - ARR  = 39999                                                           */
  /* Finterrupt = Fclk / ((PSC+1)(ARR+1)) = 32.10^6/(8*40000) = 100 Hz        */
  /*                                                          => T = 10 ms    */
  /* ------------------------------------------------------------------------ */

  /* USER CODE END TIM22_Init 1 */
  htim22.Instance = TIM22;
  htim22.Init.Prescaler = 7;
  htim22.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim22.Init.Period = 39999;
  htim22.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim22.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim22) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim22, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  sMasterConfig.MasterOutputTrigger = TIM_TRGO_RESET;
  sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
  if (HAL_TIMEx_MasterConfigSynchronization(&htim22, &sMasterConfig) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM22_Init 2 */

  /* USER CODE END TIM22_Init 2 */

}

/**
  * @brief USART1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_USART1_UART_Init(void)
{

  /* USER CODE BEGIN USART1_Init 0 */

  /* USER CODE END USART1_Init 0 */

  /* USER CODE BEGIN USART1_Init 1 */

  /* USER CODE END USART1_Init 1 */
  huart1.Instance = USART1;
  huart1.Init.BaudRate = 9600;
  huart1.Init.WordLength = UART_WORDLENGTH_8B;
  huart1.Init.StopBits = UART_STOPBITS_1;
  huart1.Init.Parity = UART_PARITY_NONE;
  huart1.Init.Mode = UART_MODE_TX_RX;
  huart1.Init.HwFlowCtl = UART_HWCONTROL_NONE;
  huart1.Init.OverSampling = UART_OVERSAMPLING_16;
  huart1.Init.OneBitSampling = UART_ONE_BIT_SAMPLE_DISABLE;
  huart1.AdvancedInit.AdvFeatureInit = UART_ADVFEATURE_NO_INIT;
  if (HAL_UART_Init(&huart1) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN USART1_Init 2 */

  /* USER CODE END USART1_Init 2 */

}

/**
  * Enable DMA controller clock
  */
static void MX_DMA_Init(void)
{

  /* DMA controller clock enable */
  __HAL_RCC_DMA1_CLK_ENABLE();

  /* DMA interrupt init */
  /* DMA1_Channel1_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(DMA1_Channel1_IRQn, 0, 0);
  HAL_NVIC_EnableIRQ(DMA1_Channel1_IRQn);
  /* DMA1_Channel2_3_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(DMA1_Channel2_3_IRQn, 0, 0);
  HAL_NVIC_EnableIRQ(DMA1_Channel2_3_IRQn);

}

/**
  * @brief GPIO Initialization Function
  * @param None
  * @retval None
  */
static void MX_GPIO_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};
  /* USER CODE BEGIN MX_GPIO_Init_1 */

  /* USER CODE END MX_GPIO_Init_1 */

  /* GPIO Ports Clock Enable */
  __HAL_RCC_GPIOA_CLK_ENABLE();
  __HAL_RCC_GPIOC_CLK_ENABLE();
  __HAL_RCC_GPIOB_CLK_ENABLE();

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOA, LED_RGB_Pin|COM_ADDR_BIT_07_Pin, GPIO_PIN_RESET);

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOC, COM_ADDR_BIT_06_Pin|COM_ADDR_BIT_05_Pin|COM_ADDR_BIT_04_Pin, GPIO_PIN_RESET);

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOB, COM_ADDR_BIT_03_Pin|COM_ADDR_BIT_02_Pin|COM_ADDR_BIT_01_Pin|RF_CARRIER_ACTIVE_Pin, GPIO_PIN_RESET);

  /*Configure GPIO pins : BTN_MODE_Pin BTN_DISP_Pin */
  GPIO_InitStruct.Pin = BTN_MODE_Pin|BTN_DISP_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_INPUT;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /*Configure GPIO pins : LED_RGB_Pin COM_ADDR_BIT_07_Pin */
  GPIO_InitStruct.Pin = LED_RGB_Pin|COM_ADDR_BIT_07_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /*Configure GPIO pins : COM_ADDR_BIT_06_Pin COM_ADDR_BIT_05_Pin COM_ADDR_BIT_04_Pin */
  GPIO_InitStruct.Pin = COM_ADDR_BIT_06_Pin|COM_ADDR_BIT_05_Pin|COM_ADDR_BIT_04_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOC, &GPIO_InitStruct);

  /*Configure GPIO pins : COM_ADDR_BIT_03_Pin COM_ADDR_BIT_02_Pin COM_ADDR_BIT_01_Pin RF_CARRIER_ACTIVE_Pin */
  GPIO_InitStruct.Pin = COM_ADDR_BIT_03_Pin|COM_ADDR_BIT_02_Pin|COM_ADDR_BIT_01_Pin|RF_CARRIER_ACTIVE_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

  /* USER CODE BEGIN MX_GPIO_Init_2 */

  /* USER CODE END MX_GPIO_Init_2 */
}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
      ADA1655_SetColor(&ADA1655_handler, 255, 0, 0);
  }
  /* USER CODE END Error_Handler_Debug */
}
#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
