/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file COM/COM_Messages_RsData.h                                            */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-12                                                           */
/*                                                                            */
/* @brief This file contains functions to encode RS_DATA messages.            */
/******************************************************************************/

#ifndef __DEF_H_WSFR48_16_COM_MESSAGES_RS_DATA__
#define __DEF_H_WSFR48_16_COM_MESSAGES_RS_DATA__

/* *************************** STANDARD INCLUDES **************************** */

#include <stdbool.h>

/* **************************** CUSTOM INCLUDES ***************************** */

#include "SUP_RsAdmin.h"
#include "TIME.h"

/* ******************************* CONSTANTS ******************************** */

#define C_COM_TRANSMIT_BUFFER_MAX_LENGTH (100) /* RS_DATA transmission buffer size */

/* *************************** TYPES DECLARATION **************************** */

typedef char tRsDataBuffer[C_COM_TRANSMIT_BUFFER_MAX_LENGTH];

typedef enum
{
    E_COM_RSDATA_CODE_UNDEFINED = 0,
    E_COM_RSDATA_CODE_PONG,
    E_COM_RSDATA_NB_CODES
}tRsData_Codes;

typedef tCmdId tPingIds[C_RSADMININ_PING_MAX_NB];

/* **************************** GLOBAL VARIABLES **************************** */

/* ************************* FUNCTIONS DECLARATION ************************** */

/******************************************************************************/
/* @function COM_Messages_Build_RSDATA                                        */
/*                                                                            */
/* @brief Formats messages for RS_DATA transmission.                          */
/* @param [in] rfCarrierActive RF carrier activation command                  */
/* @param [in] pingIds Identifiers of received PING commands                  */
/* @param [in] currentCalendar Current calendar used by the system            */
/* @param [in] newCalendar New calendar received by CALD admin command        */
/* @param [in] newTimestamp New timestamp received by TMSP admin command      */
/* @param [in|out] buffer RS_DATA content to transmit                         */
/* @req SYS_REQ-0601-001 : Construction des trames RS_DATA                    */
/******************************************************************************/
void COM_Messages_Build_RSDATA
(
    const bool rfCarrierActive,
    const tPingIds pingIds,
    const tTIME_Calendar currentCalendar,
    const tTIME_Calendar newCalendar,
    const tTIME_Timestamp newTimestamp,
    tRsDataBuffer buffer
);

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/

#endif /* __DEF_H_WSFR48_16_COM_MESSAGES_RS_DATA__ */
