/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file CONF/CONF_SystemStates.h                                             */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-06                                                           */
/*                                                                            */
/* @brief This file contains the functions to select system global state.     */
/******************************************************************************/

#ifndef __DEF_H_WSFR48_16_CONF_STATES__
#define __DEF_H_WSFR48_16_CONF_STATES__

/* *************************** STANDARD INCLUDES **************************** */

#include <stdbool.h>

/* **************************** CUSTOM INCLUDES ***************************** */

#include "TIME.h"

/* *************************** TYPES DECLARATION **************************** */

/* ========================================================================== */
/* @req SYS_REQ-0305-001 : Etats du système                                   */
/* ========================================================================== */
typedef enum
{
    E_STATE_HOME = 0,
    E_STATE_DATE,
    E_STATE_PWR,
    E_STATE_CPU,
    E_STATE_TIM,
    E_STATE_CAR,
    E_NB_STATES
} tCONF_SystemStates;
/* ========================================================================== */

/* ******************************* CONSTANTS ******************************** */

/* **************************** GLOBAL VARIABLES **************************** */

/* ************************* FUNCTIONS DECLARATION ************************** */

/******************************************************************************/
/* @function CONF_SystemState_Select                                          */
/*                                                                            */
/* @brief Selects the new system state based on previous state.               */
/* @param [in] previousState Previous system state                            */
/* @param [in] btnDispStatus DISP button activation status                    */
/* @retval New system state                                                   */
/* @req SYS_REQ-0306-001 : Changement d’état du système                       */
/******************************************************************************/
tCONF_SystemStates CONF_SystemState_Select
(
    const tCONF_SystemStates previousState,
    const bool btnDispStatus
);

/******************************************************************************/
/* @function CONF_UpdateContextWithMODE                                       */
/*                                                                            */
/* @brief Updates system context based on current system state and MODE       */
/*        button activation status.                                           */
/* @param [in] currentState Current system state                              */
/* @param [in] btnModeStatus MODE button activation status                    */
/* @param [in|out] calendar Calendar used by the system                       */
/* @param [in|out] rfCarrierActive RF carrier activation status               */
/* @req SYS_REQ-0307-001 : Opérations en état STATE_DATE                      */
/* @req SYS_REQ-0311-001 : Opérations en état STATE_CAR                       */
/******************************************************************************/
void CONF_UpdateContextWithMODE
(
    const tCONF_SystemStates currentState,
    const bool btnModeStatus,
    tTIME_Calendar * const calendar,
    bool * const rfCarrierActive
);

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/

#endif /* __DEF_H_WSFR48_16_CONF_STATES__ */
