/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file SUP/SUP_ApplyCmds.h                                                  */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-14                                                           */
/*                                                                            */
/* @brief This file contains functions to apply administration commands.      */
/******************************************************************************/

#ifndef __DEF_H_WSFR48_16_SUP_APPLYCMDS__
#define __DEF_H_WSFR48_16_SUP_APPLYCMDS__

/* *************************** STANDARD INCLUDES **************************** */

/* **************************** CUSTOM INCLUDES ***************************** */

#include "SUP_RsAdmin.h"
#include "COM_RsData.h"
#include "TIME.h"

/* ******************************* CONSTANTS ******************************** */

/* *************************** TYPES DECLARATION **************************** */

/* **************************** GLOBAL VARIABLES **************************** */

/* ************************* FUNCTIONS DECLARATION ************************** */

/******************************************************************************/
/* @function SUP_ProcessAdminCommands                                         */
/*                                                                            */
/* @brief Processes the administration commands.                              */
/* @param [in] nbCmdsReceived Number of commands received from RS_ADMIN line  */
/* @param [in] cmds Commands received from RS_ADMIN line                      */
/* @param [out] pingIds PING commands identifiers                             */
/* @param [out] pNewCalendar New calendar from CALD command                   */
/* @param [out] pNewTimestamp New timestamp from TMSP command                 */
/* @req SYS_REQ-0205-001 : Traitement des commandes d’administration – Commande PING */
/* @req SYS_REQ-0206-001 : Traitement des commandes d’administration – Commande CALD */
/* @req SYS_REQ-0207-001 : Traitement des commandes d’administration – Commande TMSP */
/******************************************************************************/
void SUP_ProcessAdminCommands
(
    const unsigned int nbCmdsReceived,
    const tRsAdmin_Cmd cmds[C_RSADMININ_MAX_CMDS],
    tPingIds pingIds,
    tTIME_Calendar * pNewCalendar,
    tTIME_Timestamp * pNewTimestamp
);

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/

#endif /* __DEF_H_WSFR48_16_SUP_APPLYCMDS__ */
