/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file SUP/SUP_PushButtons.c                                                */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-06                                                           */
/*                                                                            */
/* @brief This file contains the context and functions to handle push buttons.*/
/******************************************************************************/

#ifndef __DEF_H_WSFR48_16_SUP_PUSHBUTTONS__
#define __DEF_H_WSFR48_16_SUP_PUSHBUTTONS__

/* *************************** STANDARD INCLUDES **************************** */

/* **************************** CUSTOM INCLUDES ***************************** */

#include "PushButton.h"

/* *************************** TYPES DECLARATION **************************** */

/* ******************************* CONSTANTS ******************************** */

/* **************************** GLOBAL VARIABLES **************************** */

extern tPushButton BtnDisp_handler;
extern tPushButton BtnMode_handler;

/* ************************* FUNCTIONS DECLARATION ************************** */

/******************************************************************************/
/* @function SUP_PushButtons_ReadCurrentStates                                */
/*                                                                            */
/* @brief Read MODE and DISP push buttons states.                             */
/* @param [out] V_BTN_MODE MODE push button state (TRUE = activated)          */
/* @param [out] V_BTN_DISP DISP push button state (TRUE = activated)          */
/* @pre Buttons shall have been configured by SUP_PushButtons_Init function.  */
/* @req SYS_REQ-0208-002 : Bouton utilisateur "MODE" > Lecture de l'état      */
/* @req SYS_REQ-0209-002 : Bouton utilisateur "DISP" > Lecture de l'état      */
/******************************************************************************/
void SUP_PushButtons_ReadCurrentStates
(
    bool * const V_BTN_MODE,
    bool * const V_BTN_DISP
);

/******************************************************************************/
/* @function SUP_PushButtons_Init                                             */
/*                                                                            */
/* @brief Initializes the DISP and MODE push buttons.                         */
/* @param [in] GPIO_Port_Btn_Mode MODE button GPIO port                       */
/* @param [in] GPIO_Pin_Btn_Mode  MODE button GPIO pin                        */
/* @param [in] GPIO_Port_Btn_Disp DISP button GPIO port                       */
/* @param [in] GPIO_Pin_Btn_Disp  DISP button GPIO pin                        */
/* @req SYS_REQ-0208-002 : Bouton utilisateur "MODE" > Configuration          */
/* @req SYS_REQ-0209-002 : Bouton utilisateur "DISP" > Configuration          */
/******************************************************************************/
void SUP_PushButtons_Init
(
    GPIO_TypeDef *const GPIO_Port_Btn_Mode,
    const uint16_t GPIO_Pin_Btn_Mode,
    GPIO_TypeDef *const GPIO_Port_Btn_Disp,
    const uint16_t GPIO_Pin_Btn_Disp
);

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/

#endif /* __DEF_H_WSFR48_16_SUP_PUSHBUTTONS__ */
