/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file SUP/SUP_Reception.h                                                  */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-12                                                           */
/*                                                                            */
/* @brief This file contains functions to receive RS_ADMIN commands.          */
/******************************************************************************/

#ifndef __DEF_H_WSFR48_16_SUP_RECEPTION__
#define __DEF_H_WSFR48_16_SUP_RECEPTION__

/* *************************** STANDARD INCLUDES **************************** */

/* **************************** CUSTOM INCLUDES ***************************** */

#include "stm32l0xx_hal.h"
#include "SUP_RsAdmin.h"

/* *************************** TYPES DECLARATION **************************** */

typedef unsigned char * tSTM32_CHAR_ARRAY;

/* ******************************* CONSTANTS ******************************** */

/* **************************** GLOBAL VARIABLES **************************** */

/* ************************* FUNCTIONS DECLARATION ************************** */

/******************************************************************************/
/* @function SUP_Reception_Init                                               */
/*                                                                            */
/* @brief Initializes the transmission interface for remote equipments.       */
/* @param [in] UartHandler UART serial reception line handler                 */
/* @req SYS_REQ-0201-002 : Interface RS administration > Configuration        */
/******************************************************************************/
void SUP_Reception_Init(UART_HandleTypeDef * const UartHandler);

/******************************************************************************/
/* @function SUP_Reception_ReceiveData                                        */
/*                                                                            */
/* @brief Receives data from RS_ADMIN_IN RS line.                             */
/* @param [in] buffer Content received on RS_ADMIN_IN reception line          */
/* @req SYS_REQ-0201-002 : Interface RS administration > Reception            */
/******************************************************************************/
void SUP_Reception_ReceiveData(tRsAdminBuffer buffer);

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/

#endif /* __DEF_H_WSFR48_16_SUP_RECEPTION__ */
