/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/
/* @file SCR/SCR.h                                                            */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.0                                                               */
/* @date 2025-09-06                                                           */
/*                                                                            */
/* @brief This file contains functions to select and display information      */
/*        pages on the SCR_USR user screen.                                   */
/******************************************************************************/

#ifndef __DEF_H_WSFR48_16_SCR__
#define __DEF_H_WSFR48_16_SCR__

/* *************************** STANDARD INCLUDES **************************** */

#include <stdbool.h>

/* **************************** CUSTOM INCLUDES ***************************** */

#include "stm32l0xx_hal.h"

/* *************************** TYPES DECLARATION **************************** */

typedef enum
{
    E_STATE_HOME = 0,
	E_STATE_TIM,
    E_STATE_PWR,
    E_STATE_CAR,
    E_NB_STATES
} tCONF_SystemStates;

/* ******************************* CONSTANTS ******************************** */

/* **************************** GLOBAL VARIABLES **************************** */

/* ************************* FUNCTIONS DECLARATION ************************** */

/******************************************************************************/
/* @function SCR_DisplayContent                                               */
/*                                                                            */
/* @brief Displays informations on SCR_USR user screen.                       */
/* @param [in] system_state      Current system state                         */
/* @param [in] ps_p_voltage      Positive power source voltage                */
/* @param [in] ps_n_voltage      Negative power source voltage                */
/* @param [in] tim22_frequency   TIM22 timer frequency                        */
/* @param [in] rf_carrier_active RF carrier activation status                 */
/* @pre The SCR_USR screen shall have been configured by SCR_Init function.   */
/* @req SYS_REQ-0401-001 : Paramètres de l’écran utilisateur                  */
/******************************************************************************/
void SCR_DisplayContent
(
    const tCONF_SystemStates system_state,
    const double ps_p_voltage,
    const double ps_n_voltage,
	const double tim22_frequency,
    const bool rf_carrier_active
);

/******************************************************************************/
/* @function SCR_Init                                                         */
/*                                                                            */
/* @brief Initializes SCR_USR user screen.                                    */
/* @req SYS_REQ-0401-001 : Paramètres de l’écran utilisateur                  */
/******************************************************************************/
void SCR_Init(void);

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                       48th edition - Marseille 2025                        */
/*                       Electronique (16) - SyncOrSink                       */
/*                                                                            */
/******************************************************************************/

#endif /* __DEF_H_WSFR48_16_SCR__ */
