/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                              Electronique (16)                             */
/*                                                                            */
/******************************************************************************/
/* @file ADA1655.h                                                            */
/* @authors WorldSkills France "Electronique" skill team                      */
/* @version 1.1                                                               */
/* @date 2025-07-11                                                           */
/*                                                                            */
/* @brief ADA1655 driver abstraction layer.                                   */
/*        This file contains functions to interact with Adafruit ADA1655 led  */
/*        component.                                                          */
/*        WARNING : THIS CODE IS CALIBRATED TO WORK WITH A SYSCLK CLOCK SET   */
/*        TO 24MHz.                                                           */
/******************************************************************************/

#ifndef __DEF_H_WSFR_16_ADA1655__
#define __DEF_H_WSFR_16_ADA1655__

#include "stm32l0xx_hal.h"

typedef struct
{
    GPIO_TypeDef * gpio_port; /* ADA1655 component GPIO port */
    uint16_t gpio_pin; /* ADA1655 component GPIO pin */
}tAda1655;

void ADA1655_SetControlPin(tAda1655 * const pAda1655, GPIO_TypeDef * const GPIO_Port, const uint16_t GPIO_Pin);
void ADA1655_SetColor(const tAda1655 * const pAda1655, const uint8_t r, const uint8_t g, const uint8_t b);
void ADA1655_Reset(tAda1655 * const pAda1655);

#endif /* __DEF_H_WSFR_16_ADA1655__ */

/******************************************************************************/
/*                                                                            */
/*                             WorldSkills France                             */
/*                              Electronique (16)                             */
/*                                                                            */
/******************************************************************************/
