# API ProfPerso 

## Installation 

### Avec Docker

Pour simplifier l'installation de l'ensemble du système, il a été mis sous la forme d'un conteneur Docker.

Pour installer rapidement l'API, Docker devra donc être installé sur le serveur

Pour vérifier :

```bash
docker --version

Docker version 20.10.23, build 7155243
```

Il faudra alors construir le conteneur

```bash
docker compose build
```

Puis lancer l'exécution du conteneur

```bash
docker compose up
```


### Installation sans Docker 

Pré-requis :

- [PostgreSQL](https://www.postgresql.org/)
- [NodeJS et NPM](https://nodejs.org/en/)

#### Mise en place de la base de données

Une fois installé, connectez-vous au serveur PostgreSQL à l'aide du compte administrateur `postgres`.

Il faudra ensuite créer un utilisateur `profperso` qui aura le mot de passe `profperso`

```sql
CREATE USER profperso WITH ENCRYPTED PASSWORD 'profperso';
```

Puis créer la base de données liée à l'application

```sql
CREATE DATABASE profperso WITH OWNER profperso;
```

#### Installer et lancer le serveur

Dans un terminal, placez-vous dans le répertoir du projet et lancer un 
```bash
npm install
```

vous pouvez ensuite lancer le serveur avec la commande 
```bash
npm run start
```

#### Gérer plus facilement le serveur

On peut aussi lancer le serveur avec un outil de gestion de processus comme pm2

```bash
npm install -g pm2
```

Puis, depuis le répertoire du projet 

```bash
npm run start-pm2
```


## Utilisation 

Une fois le serveur installé et lancé, il écoutera sur le port 3000 du serveur

L'accès à la ducmentation de l'API se fera depuis l'url :

```
http://<host>:3000/api-docs
```