
const Level = require('../src/models/level');
const Domain = require('../src/models/domain');
const Question = require('../src/models/question');
const Answer = require('../src/models/answer');
const pg = require('pg');

module.exports = async function () {
    await Answer.drop();
    await Question.drop();
    await Level.drop();
    await Domain.drop();



    await Level.sync({
        force: false,
    });
    await Domain.sync({
        force: false,
    });
    await Question.sync({
        force: false,
    });
    await Answer.sync({
        force: false,
    });


    await Level.create({
        label: 'Débutant',
    });

    await Level.create({
        label: 'Intermédiaire',
    });

    await Level.create({
        label: 'Avancé',
    });


    await Domain.create({
        label: 'Français',
    });

    await Domain.create({
        label: 'Mathématiques',
    });

    await Domain.create({
        label: 'Histoire',
    });

    await Domain.create({
        label: 'Géographie',
    });

    await Domain.create({
        label: 'Physique',
    });

    await Domain.create({
        label: 'Chimie',
    });

    await Domain.create({
        label: 'SVT',
    });

    await Domain.create({
        label: 'Anglais',
    });

    await Domain.create({
        label: 'Espagnol',
    });


    await Question.create({
        intitule: 'Quel est le nom du président de la République française ?',
        infos: 'Le président de la République française est élu pour cinq ans au suffrage universel direct. Il est élu par le peuple français, qui lui confère le pouvoir exécutif. ',
        redactor: 'Professeur de d\'histoire',
        level_id: 1,
        domain_id: 3,
    });

    await Question.create({
        intitule: 'Quel pays à pour capitale Kingston ?',
        infos: 'La Jamaïque est un pays insulaire de l\'océan Atlantique, situé dans les Petites Antilles. Il est constitué de trois îles principales : la Jamaïque, la plus grande, et les îles de la Grenade et de la Trinité. ',
        level_id: 1,
        domain_id: 4,
    });

    await Answer.create({
        content: 'Emmanuel Macron',
        is_correct: true,
        question_id: 1,
    });

    await Answer.create({
        content: 'François Hollande',
        is_correct: false,
        question_id: 1,
    });

    await Answer.create({
        content: 'Jacques Chirac',
        is_correct: false,
        question_id: 1,
    });

    await Answer.create({
        content: 'Nicolas Sarkozy',
        is_correct: false,
        question_id: 1,
    });

    await Answer.create({

        content: 'Jamaïque',
        is_correct: true,
        question_id: 2,
    });

    await Answer.create({
        content: 'Haïti',
        is_correct: false,
        question_id: 2,
    });

    await Answer.create({
        content: 'Trinité-et-Tobago',
        is_correct: false,
        question_id: 2,
    });

    await Answer.create({
        content: 'Saint-Vincent-et-les-Grenadines',
        is_correct: false,
        question_id: 2,
    });



}