
BEGIN;

DROP TABLE IF EXISTS "domain" ;
DROP TABLE IF EXISTS "level" ;
DROP TABLE IF EXISTS "question" ;
DROP TABLE IF EXISTS "answer" ;

CREATE TABLE "domain" (
  "id" INTEGER GENERATED ALWAYS AS IDENTITY PRIMARY KEY, 
  "label" TEXT NOT NULL,
  "created_at" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  "updated_at" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE "level" (
    "id" INTEGER GENERATED ALWAYS AS IDENTITY PRIMARY KEY, 
    "label" TEXT NOT NULL,
    "created_at" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE "question"(
    "id" INTEGER GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    "intitule" TEXT NOT NULL,
    "infos" TEXT,
    "is_active" BOOLEAN NOT NULL DEFAULT TRUE,
    "domain_id" INTEGER NOT NULL,
    "level_id" INTEGER NOT NULL,
    "redactor" TEXT NOT NULL,
    "created_at" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE "answer"(
    "id" INTEGER GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    "content" TEXT NOT NULL,
    "is_correct" BOOLEAN NOT NULL DEFAULT FALSE,
    "question_id" INTEGER NOT NULL,
    "created_at" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updated_at" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
);

COMMIT;
