require('dotenv').config();
const cors = require('cors');
const express = require('express');
const swaggerUi = require('swagger-ui-express');
const swaggerJSDoc = require('swagger-jsdoc');
const router = require('./src/routers/router');
const generateStructure = require('./db/generateStructure');
const options = {
  definition: {
    openapi: '3.0.0',
    info: {
      title: `ProfPerso API`,
      version: '1.0.0',
    },
  },
  apis: ['./src/routers/router.js'], // files containing annotations as above
};


const swaggerSpec = swaggerJSDoc(options);

// Création de l'application
const app = express();
const PORT = process.env.SERVER_PORT || 3000;

// Configuration de l'application
app.use(express.json());
app.use(express.json({ limit: '50mb' }));

app.use(cors());
app.use(express.static('public'));
app.use('/api-docs', swaggerUi.serve, swaggerUi.setup(swaggerSpec));
app.use(router);

// Démarrage du serveur

(async () => {
  const { Level, Domain, Question, Answer } = require('./src/models/index');
  try {
    await generateStructure();
    console.log('Database is connected');
    app.listen(PORT, () => {
      console.log(`server is runing at port ${PORT}`);
    });
  } catch (err) {
    console.log(err);
  }
})();
