const {Answer} = require('../models');

const answerController = {
    getAnswers: async (req, res) => {
        const answers = await Answer.findAll();
        res.status(200).json({answers});
    },
    getAnswer: async (req, res) => {
        const {id} = req.params;
        const answer = await Answer.findByPk(id);
        res.status(200).json({answer});
    },
    getAnswersByQuestion: async (req, res) => {
        const {id} = req.params;
        const answers = await Answer.findAll({
            where: {
                question_id: id
            }
        });
        res.status(200).json({answers});
    },
    createAnswer: async (req, res) => {
        const {content, is_correct, question_id} = req.body;
        const answer = await Answer.create({
            content,
            is_correct,
            question_id
        });
        res.status(201).json({answer});
    },
    updateAnswer: async (req, res) => {
        const {id} = req.params;
        const {intitule, is_correct, question_id} = req.body;
        const answer = await Answer.update({
            intitule,
            is_correct,
            question_id
        }, {
            where: {
                id
            }
        });
        res.status(200).json({answer});
    },
    deleteAnswer: async (req, res) => {
        const {id} = req.params;
        const answer = await Answer.destroy({
            where: {
                id
            }
        });
        res.status(200).json({answer});
    }
}

module.exports = answerController;