const {Domain} = require('../models');

const domainController = {
    getDomains: async (req, res) => {
        const domains = await Domain.findAll();
        res.status(200).json({domains});
    },
    getDomain: async (req, res) => {
        const {id} = req.params;
        const domain = await Domain.findByPk(id);
        res.status(200).json({domain});
    }
}

module.exports = domainController;


