const {Question} = require('../models');

const questionController = {
    getQuestions: async (req, res) => {
        const questions = await Question.findAll({
            include: ['level', 'domain', 'answers']
        }
        );
        res.status(200).json({questions});
    },
    getQuestion: async (req, res) => {
        const {id} = req.params;
        const question = await Question.findByPk(id, {
            include: ['level', 'domain', 'answers']
        });
        res.status(200).json({question});
    },
    getQuestionsByLevelAndDomainAndActive: async (req, res) => {
        const {level_id, domain_id} = req.params;
        const questions = await Question.findAll({
            where: {
                level_id,
                domain_id,
                is_active: true
            },
            include: ['level', 'domain', 'answers']
        });
        res.status(200).json({questions});
    }, 
    createQuestion: async (req, res) => {
        const {intitule, infos, redactor, level_id, domain_id} = req.body;
        const question = await Question.create({
            intitule,
            infos,
            redactor,
            level_id,
            domain_id
        });
        res.status(201).json({question});
    },
    updateQuestion: async (req, res) => {
        const {id} = req.params;
        const {intitule, infos, is_active, redactor, level_id, domain_id} = req.body;
        const question = await Question.update({
            intitule,
            infos,
            is_active,
            redactor,
            level_id,
            domain_id
        }, {
            where: {
                id
            }
        });
        res.status(200).json({question});
    },
    deleteQuestion: async (req, res) => {
        const {id} = req.params;
        const question = await Question.destroy({
            where: {
                id
            }
        });
        res.status(200).json({question});
    }
}

module.exports = questionController;