const sequelize = require('../utils/database');
const Sequelize = require('sequelize');

class Answer extends Sequelize.Model { };

Answer.init({
    content: {
        type: Sequelize.STRING,
        allowNull: false,
    },
    is_correct: {
        type: Sequelize.BOOLEAN,
        allowNull: false,
    },
    created_at: {
        type: Sequelize.DATE,
        defaultValue: Sequelize.NOW
    },
    updated_at: {
        type: Sequelize.DATE,
        defaultValue: Sequelize.NOW
    },
}, {
    sequelize,
    tableName: "answer"
});

module.exports = Answer;
