const Level = require('./level');
const Domain = require('./domain');
const Question = require('./question');
const Answer = require('./answer');

Question.belongsTo(Level, { foreignKey: 'level_id', as: 'level' });
Question.belongsTo(Domain, { foreignKey: 'domain_id', as: 'domain' });
Question.hasMany(Answer, { foreignKey: 'question_id', as: 'answers' });
Answer.belongsTo(Question, { foreignKey: 'question_id', as: 'question' });

module.exports = {Level, Domain, Question, Answer};

