const sequelize = require('../utils/database');
const Sequelize = require('sequelize');

class Question extends Sequelize.Model { };

Question.init({
    intitule: {
        type: Sequelize.STRING,
        allowNull: false,
    },
    infos: Sequelize.TEXT,
    is_active: {
        type: Sequelize.BOOLEAN,
        allowNull: false,
        defaultValue: true
    },
    redactor: Sequelize.STRING,
    created_at: {
        type: Sequelize.DATE,
        defaultValue: Sequelize.NOW
    },
    updated_at: {
        type: Sequelize.DATE,
        defaultValue: Sequelize.NOW
    },
}, {
    sequelize,
    tableName: "question"
});

module.exports = Question;