const {Sequelize} = require('sequelize');
require('dotenv').config();

const URL = `postgresql://${process.env.DB_USER}:${process.env.DB_PASSWORD}@${process.env.DB_HOST}/${process.env.DB_NAME}`;

const sequelize = new Sequelize(URL, { 
    logging: false,
    define: {
        updatedAt: 'updated_at',
        createdAt: 'created_at'
    }
});

module.exports = sequelize;